<?php $__env->startSection('title', __('sale.status')); ?>

<?php $__env->startSection('content'); ?>
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('plugins/bootstrap-colorpicker/bootstrap-colorpicker.min.css')); ?>">

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1><?php echo e(app('translator')->getFromJson('sale.status')); ?>
    </h1>
</section>

<!-- Main content -->
<section class="content">
    <?php $__env->startComponent('components.widget', ['class' => 'box-primary', 'title' => __( 'repair::lang.all_repair_statuses' )]); ?>
        <?php $__env->slot('tool'); ?>
            <div class="box-tools">
                <button type="button" class="btn btn-block btn-primary btn-modal" 
                    data-href="<?php echo e(action('\Modules\Repair\Http\Controllers\RepairStatusController@create')); ?>" 
                    data-container=".view_modal">
                    <i class="fa fa-plus"></i> <?php echo e(app('translator')->getFromJson( 'messages.add' )); ?></button>
            </div>
        <?php $__env->endSlot(); ?>
        <table class="table table-bordered table-striped" id="status_table">
            <thead>
                <tr>
                    <th><?php echo e(app('translator')->getFromJson( 'repair::lang.status_name' )); ?></th>
                    <th><?php echo e(app('translator')->getFromJson( 'repair::lang.color' )); ?></th>
                    <th><?php echo e(app('translator')->getFromJson( 'repair::lang.priority' )); ?></th>
                    <th><?php echo e(app('translator')->getFromJson( 'messages.action' )); ?></th>
                </tr>
            </thead>
        </table>
    <?php echo $__env->renderComponent(); ?>

    <div class="modal fade brands_modal" tabindex="-1" role="dialog" 
    	aria-labelledby="gridSystemModalLabel">
    </div>

</section>
<!-- /.content -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
<script src="<?php echo e(asset('plugins/bootstrap-colorpicker/bootstrap-colorpicker.min.js')); ?>"></script>
<script type="text/javascript">
    $(document).ready( function(){
        //Status table
        var status_table = $('#status_table').DataTable({
                processing: true,
                serverSide: true,
                ajax: "<?php echo e(action('\Modules\Repair\Http\Controllers\RepairStatusController@index')); ?>",
                columnDefs: [ {
                    "targets": 3,
                    "orderable": false,
                    "searchable": false
                } ]
            });

        $(document).on('submit', 'form#status_form', function(e){
            e.preventDefault();
            $(this).find('button[type="submit"]').attr('disabled', true);
            var data = $(this).serialize();

            $.ajax({
                method: $(this).attr('method'),
                url: $(this).attr("action"),
                dataType: "json",
                data: data,
                success: function(result){
                    if(result.success == true){
                        $('div.view_modal').modal('hide');
                        toastr.success(result.msg);
                        status_table.ajax.reload();
                    } else {
                        toastr.error(result.msg);
                    }
                }
            });
        });
    });
    $(document).on('shown.bs.modal', '.view_modal', function() {
        $('input#color').colorpicker({format: 'hex'});
    })
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>